-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.qDoneFarm = 0
      self.qDoneForest = 0
      self.qDoneST = 0
			self.allQuests = 0
    end
  end
  
  if self.qDoneFarm == 2 then
    self.p0:WinQuest('D06_FARMS')
    self.p0:AddResource(0, 140)
    self.p0:AddResource(6, 30)
		self.allQuests = self.allQuests + 1
    self.qDoneFarm = 0
  end
  
  if self.qDoneST == 3 then
    self.p0:WinQuest('D06_SMALL_TOWN')
    self.p0:AddResource(8, 500)
    self.p0:AddResource(7, 40)
    self.p0:AddResource(6, 40)
    self.p0:AddResource(5, 60)
		self.allQuests = self.allQuests + 1
    self.qDoneST = 0
  end
  
  if self.qDoneForest == 2 then
    self.p0:WinQuest('D06_FOREST')
    self.p0:AddResource(1, 200)
    self.p0:AddResource(5, 30)
		self.allQuests = self.allQuests + 1
    self.qDoneForest = 0
  end  
	
	if self.allQuests == 3 then
		self.p0:UnlockCharacter("D_Earl-Ragnall")
		self.allQuests = 0
	end	
end

function OnTrigger(self, source, target)
  if target == "questFarms" then
    self.qDoneFarm = self.qDoneFarm + 1
  elseif target == "questForest" then
    self.qDoneForest = self.qDoneForest + 1
  elseif target == "questSmallTown" then
    self.qDoneST = self.qDoneST + 1
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.qDoneFarm = ar:Read()
    self.qDoneForest = ar:Read()
    self.qDoneST = ar:Read()
		self.allQuests = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.qDoneFarm)
    ar:Write(self.qDoneForest)
    ar:Write(self.qDoneST)
		ar:Write(self.allQuests)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("questFarms")
  self:AddTriggerTarget("questForest")
  self:AddTriggerTarget("questSmallTown")
end
